import UIKit

class ViewController: UIViewController
{
    @IBOutlet weak var recordButton: UIButton!
    @IBOutlet weak var canvas: UIView!
    @IBOutlet weak var ball: UIView!
    
    var recording : Bool = false
    var locsArr : Array <CGPoint> = []
    
    
    override func viewWillAppear(_ animated: Bool)
    {
        super.viewWillAppear(true)
        ball.layer.cornerRadius = ball.bounds.size.width / 2.0
    }
    
    @IBAction func recordAction(_ sender: Any)
    {
        if recording
        {
            recordButton.backgroundColor = UIColor.orange
            recording = false
        }
        else
        {
            locsArr = []
            // clear the canvas as well
            for anyView in canvas.subviews
            {
                if (anyView != ball)
                {
                    anyView.removeFromSuperview()
                }
            }
            
            
            recordButton.backgroundColor = UIColor.red
            recording = true
        }
    }
    
    override func touchesMoved(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        let myTouch = touches.first
        
        if myTouch?.view != canvas || !recording
        {
            return
        }
        
        locsArr.append((myTouch?.location(in: canvas))!)
        
        let guide = UIView (frame: CGRect(x: 0,
                                          y: 0,
                                          width: 6,
                                          height: 6))
        guide.backgroundColor = UIColor.purple
        guide.layer.cornerRadius = 3
        guide.center = (myTouch?.location(in: canvas))!
        canvas.addSubview(guide)
    }
    
    
    @IBAction func animateAction(_ sender: Any)
    {
        if (locsArr.count < 2 || recording)
        {
            return // give user an indication
        }
        
        
        let anim = CAKeyframeAnimation(keyPath: #keyPath (CALayer.position))
        
        anim.values = locsArr
        anim.duration = 3.0
        
        ball.layer.add(anim,
                       forKey: "pathKey")
    }
}

